import refreshTokenHelper from "../../../../../utils/refreshTokenHelper"
import forceLogoutHelper from "../../../../../utils/forceLogoutHelper"
import errorHandlingHelper from "../../../../../utils/errorHandlingHelper"
import fetchHelper from "../../../../../utils/fetchHelper"

const handleFunc = async (event: any, authToken: any = null) => {
  let data: any = {}
  const token = authToken ?? await getTokenHelper(event)
  const body = await readBody(event)

  let newObjValue = {}
  if(body.locatorTypeId) {
    newObjValue = {...newObjValue, 
      M_LocatorType_ID: {
        id: body.locatorTypeId,
        tableName: 'M_LocatorType'
      }
    }
  }

  if(body.id) {
    const res: any = await fetchHelper(event, 'models/m_locator/'+body.id, 'PUT', token, {
      isActive: body.isActive,
      value: body.value,
      priorityNo: body.priorityNo,
      X: body.x,
      Y: body.y,
      Z: body.z,
      isDefault: body.isDefault,
      ...newObjValue,
      tableName: 'm_locator'
    })
    if(res) {
      data = res
      data['status'] = 200
      data['message'] = ''
    }
  }

  return data
}

export default defineEventHandler(async (event) => {
  let data: any = {}

  try {
    data = await handleFunc(event)
  } catch(err: any) {
    try {
      let authToken: any = await refreshTokenHelper(event)
      data = await handleFunc(event, authToken)
    } catch(error: any) {
      data = errorHandlingHelper(err?.data ?? err, error?.data ?? error)
      forceLogoutHelper(event, data)
    }
  }

  return data
})